/*
 * Decompiled with CFR 0.152.
 */
package com.mlib.contexts;

import com.mlib.Utility;
import com.mlib.contexts.base.Condition;
import com.mlib.contexts.base.Context;
import com.mlib.contexts.base.Contexts;
import com.mlib.contexts.data.IEntityData;
import java.util.function.Consumer;
import javax.annotation.Nullable;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;

public class OnPreDamaged {
    public static final Consumer<Data> CANCEL = data -> {
        data.isCancelled = true;
    };

    public static Context<Data> listen(Consumer<Data> consumer) {
        return Contexts.get(Data.class).add(consumer);
    }

    public static Data dispatch(DamageSource source, LivingEntity target, float damage) {
        return Contexts.get(Data.class).dispatch(new Data(source, target, damage));
    }

    public static Condition<Data> isDirect() {
        return new Condition<Data>(Data::isDirect);
    }

    public static Condition<Data> dealtAnyDamage() {
        return new Condition<Data>(Data::dealtAnyDamage);
    }

    public static Condition<Data> willTakeFullDamage() {
        return new Condition<Data>(Data::willTakeFullDamage);
    }

    public static class Data
    implements IEntityData {
        public final DamageSource source;
        @Nullable
        public final LivingEntity attacker;
        public final LivingEntity target;
        public final float damage;
        public float extraDamage = 0.0f;
        public boolean isCancelled = false;
        public boolean spawnCriticalParticles = false;
        public boolean spawnMagicParticles = false;

        public Data(DamageSource source, LivingEntity target, float damage) {
            this.source = source;
            this.attacker = Utility.castIfPossible(LivingEntity.class, this.source.m_7639_());
            this.target = target;
            this.damage = damage;
        }

        @Override
        public Entity getEntity() {
            return this.target;
        }

        public boolean isDirect() {
            return this.source.m_7640_() == this.attacker;
        }

        public boolean dealtAnyDamage() {
            return this.damage > 0.0f;
        }

        public boolean willTakeFullDamage() {
            return this.target.f_19802_ <= 10;
        }
    }
}

